function showToast(message) {

    var toast = document.createElement('div');
    toast.classList.add('toast');
    toast.classList.add('show');
    toast.style.position = 'fixed';
    toast.style.top = '20px';
    toast.style.right = '20px';
    toast.style.zIndex = '1050';

    var toastBody = document.createElement('div');
    toastBody.classList.add('toast-body');
    toastBody.style.color = 'black'; // Asegura que el texto sea blanco
    toastBody.innerText = message;
    toast.appendChild(toastBody);

    document.body.appendChild(toast);

    setTimeout(function () {
        toast.classList.remove('show');
        setTimeout(function () {
            document.body.removeChild(toast);
        }, 300);
    }, 3000);
}



function showDangerToast(message) {

    var toast = document.createElement('div');
    toast.classList.add('toast');
    toast.classList.add('show');
    toast.classList.add('bg-danger'); // Clase de Bootstrap para fondo rojo
    toast.style.position = 'fixed';
    toast.style.top = '20px';
    toast.style.right = '20px';
    toast.style.zIndex = '1050';

    var toastBody = document.createElement('div');
    toastBody.classList.add('toast-body');
    toastBody.style.color = 'white';
    toastBody.innerText = message;
    toast.appendChild(toastBody);

    document.body.appendChild(toast);

    setTimeout(function () {
        toast.classList.remove('show');
        setTimeout(function () {
            document.body.removeChild(toast);
        }, 300);
    }, 3000);
}


function showDarkToast(message) {
    // Crear el contenedor del toast
    var toast = document.createElement('div');
    toast.classList.add('toast');
    toast.classList.add('show');
    toast.classList.add('bg-dark'); // Clase de Bootstrap para fondo oscuro
    toast.style.position = 'fixed';
    toast.style.top = '20px';
    toast.style.right = '20px';
    toast.style.zIndex = '1050';

    // Crear el cuerpo del toast
    var toastBody = document.createElement('div');
    toastBody.classList.add('toast-body');
    toastBody.style.color = 'white'; // Color del texto blanco para contrastar con el fondo oscuro
    toastBody.innerText = message;
    toast.appendChild(toastBody);

    // Añadir el toast al cuerpo del documento
    document.body.appendChild(toast);

    // Quitar el toast después de 3 segundos
    setTimeout(function () {
        toast.classList.remove('show');
        setTimeout(function () {
            document.body.removeChild(toast);
        }, 300);
    }, 3000);
}



function showPrimaryToast(message) {

    var toast = document.createElement('div');
    toast.classList.add('toast');
    toast.classList.add('show');
    toast.classList.add('bg-primary'); // Clase de Bootstrap para fondo rojo
    toast.style.position = 'fixed';
    toast.style.top = '20px';
    toast.style.right = '20px';
    toast.style.zIndex = '1050';

    var toastBody = document.createElement('div');
    toastBody.classList.add('toast-body');
    toastBody.style.color = 'white';
    toastBody.innerText = message;
    toast.appendChild(toastBody);

    document.body.appendChild(toast);

    setTimeout(function () {
        toast.classList.remove('show');
        setTimeout(function () {
            document.body.removeChild(toast);
        }, 300);
    }, 3000);
}

async function postData(apiUrl, dataToSend) {
    return callApi(apiUrl, dataToSend, 'POST');
}

async function putData(apiUrl, dataToSend) {
    return callApi(apiUrl, dataToSend, 'PUT');
}

async function getData(apiUrl) {

    var data;

    try {

        // Realizamos la solicitud fetch y esperamos la respuesta
        const response = await fetch(apiUrl);
        const status = response.status;
        data = await response.json();

        if (status != 200) {
            data.error = "Error:  " + data.error;
        }

    } catch (err) {
        data.error = err.message;
        console.log(data.error);
    }
    
    return data;
}


async function callApi(apiUrl, dataToSend, method) {
    var data;

    // Configuración de la solicitud
    const requestOptions = {
        method: method,
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify(dataToSend)
    };

    try {
        // Realizamos la solicitud fetch y esperamos la respuesta
        const response = await fetch(apiUrl, requestOptions);
        const status = response.status;
        data = await response.json();
        
        if (status != 200) {
            data.error = "Error:  " + data.error;
        }

    } catch (err) {
        data = err.message;
    }

    return data;
}


async function deleteData(apiUrl) {
    var error = "";

    // Configuración de la solicitud DELETE
    const requestOptions = {
        method: 'DELETE'
    };

    try {
        // Realizamos la solicitud fetch y esperamos la respuesta
        const response = await fetch(apiUrl, requestOptions);
        const status = response.status;
        const data = await response.json();

        //console.log('Respuesta del servidor:', data);

        if (status != 200) {
            error = "Error:  " + data.mensaje;
        }

    } catch (error) {
        error = error.message;
    }

    return error;
}



async function postProcess(apiUrl, dataToSend, method) {

    var data = {};

    // Configuración de la solicitud
    const requestOptions = {
        method: "POST",
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify(dataToSend)
    };

    try {
        // Realizamos la solicitud fetch y esperamos la respuesta
        const response = await fetch(apiUrl, requestOptions);
        const status = response.status;
        data = await response.json();
        
        if (status != 200) {
            data.error = "Error:  " + data.error;
        }
    } catch (error) {
        data.error = "Error: "  + error.message;
    }

    return data;
}


function Logout(){
    window.location.href = "/logout";
}


function GetUser() {
    let user = sessionStorage.getItem("usuario");
    if (user != null) $("#spUsuario").text("@" + user);
}


GetUser();


function isDecimal(text) {
    return !isNaN(text);
}


function isInteger(text) {
    return Number.isInteger(Number(text));
}

function isValidEmail(email) {
    const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
    return emailRegex.test(email);
}
