$(function () {

    GetUser();
    CargarTabla([]);
    CargarRegistros();

    $("#btnNuevo").on("click", function (e) {
        Nuevo();
    });

    $("#btnAlmacenar").on("click", function (e) {
        Almacenar();
    });

    $("#btnEliminar").on("click", function (e) {
        Eliminar();
    });

    $("#btnPassword").on("click", function (e) {
        Password();
        return true;
    });

});

var api = "/local/usuarios";
var registros = [];

function GetUser() {
    let user = sessionStorage.getItem("usuario");
    if (user != null) $("#spUsuario").text("@" + user);
}


async function CargarRegistros() {
    
    try{
        $("#divLoading").show();
        var result = await getData(api);
        $("#divLoading").hide();

        if(result.error){
            MensajeError(result.error);
            return;
        }
    
        registros = result;
        CargarTabla(registros);
    }
    catch(err){
        MensajeError(err.message);
    }
}


function Nuevo() {

    $("#hfId").val("");
    $("#txtNombre").val("");

    $("#txtClave").val("");
    $("#txtUsuario").val("");
    $("#ddlTipo").val(0);
    $("#divClave").show();

    $('#spTitulo').text('Nuevo Usuario');
    $('#procesoModal').modal('show');
}


async function Almacenar() {

    var error = "";
    var id = $("#hfId").val();
    var nombre = $("#txtNombre").val().trim();
    var usuario = $("#txtUsuario").val().trim();
    var clave = $("#txtClave").val().trim();
    var tipo = $("#ddlTipo").val();
    var tipoText = $("#ddlTipo option:selected").text();

    if (tipo == 0) {
        MensajeError("Seleccione Tipo");
        return;
    }

    if (nombre == "") {
        MensajeError("Ingrese Nombre");
        return;
    }

    if (usuario == "") {
        MensajeError("Ingrese Usuario");
        return;
    }

    if (clave == "") {
        MensajeError("Ingrese Clave");
        return;
    }

    var dto = { nombre: nombre, usuario: usuario, clave: clave, tipo: tipoText };

    if (id == "") {

        $("#divLoading").show();
        let result = await postData(api, dto);
        $("#divLoading").hide();

        if (result.error) {
            MensajeError(error);
            return;
        }

        MensajeExitoso("registro almacenado");
    }
    else {

        $("#divLoading").show();
        let result = await putData(api + "/" + id, dto);
        $("#divLoading").hide();

        if (result.error) {
            MensajeError(result.error);
            return;
        }

        MensajeExitoso("registro actualizado");
    }

    $("#hfId").val("");
    CargarRegistros();

    $('#procesoModal').modal('hide');
}


function Editar(id) {

    var index = registros.findIndex(a => a.id_usuario == id);
    var dto = registros[index];
    var idTipo = dto.tipo == "ADMIN" ? 1 : 2;

    $("#hfId").val(id);
    $("#ddlTipo").val(idTipo);
    $("#txtNombre").val(dto.nombre);
    $("#txtUsuario").val(dto.usuario);
    $("#txtClave").val(dto.clave);
    $("#divClave").hide();

    $('#spTitulo').html('Editar Usuario');
    $('#procesoModal').modal('show');
}


function Borrar(id) {

    $("#hfId").val(id);
    var index = registros.findIndex(a => a.id_usuario == id);
    var dto = registros[index];

    $('#spTituloDe').html('Eliminar Usuario: ' + dto.usuario);
    $("#spObservacionDe").html("¿Esta seguro de eliminar este registro?")
    $('#procesoEliminar').modal('show');
}


async function Eliminar() {
    var id = $("#hfId").val();
    $("#divLoading").show();
    var result = await deleteData(api + "/" + id);
    $("#divLoading").hide();

    if (result.error) {
        MensajeError(result.error);
        return;
    }

    $("#hfId").val("");
    CargarRegistros();

    $('#procesoEliminar').modal('hide');
    MensajeExitoso("registro eliminado");
}


function CargarTabla(dataSet) {
    var t = $('#tbRegistros').DataTable({
        data: dataSet,
        pageLength: 5,
        bLengthChange: false,
        ordering: true,
        destroy: true,
        bPaginate: true,
        bFilter: true,
        //bServerSide: false,
        searching: true,
        autoWidth: false,
        info: true,
        aoColumns: [
            { mData: "id_usuario" },
            { mData: "tipo" },
            { mData: "usuario" },
            { mData: "nombre" },
            { mData: "createdAt" },
        ],
        aoColumnDefs: [
            {
                "aTargets": [5],
                "bSearchable": false,
                "bSortable": false,
                "Width": "30px",
                "mRender": function (data, type, full, meta) {
                    return '<a href="javascript:Editar(' + full.id_usuario + ');" class="btn btn-ligth btn-sm">Editar</span></a>';
                }
            },
            {
                "aTargets": [6],
                "bSearchable": false,
                "bSortable": false,
                "Width": "30px",
                "mRender": function (data, type, full, meta) {
                    return '<a href="javascript:CambiarPassword(' + full.id_usuario + ');" class="btn btn-ligth btn-sm">Password</span></a>';
                }
            },
            {
                "aTargets": [7],
                "bSearchable": false,
                "bSortable": false,
                "Width": "30px",
                "mRender": function (data, type, full, meta) {
                    return '<a href="javascript:Borrar(' + full.id_usuario + ');" class="btn btn-ligth btn-sm">Borrar</span></a>';
                }
            }
        ],
        order: [[0, 'desc']], // Esto establecerá el orden inicial en la primera columna (cambiar el índice según sea necesario) en orden descendente
        language: {
            sProcessing: "Procesando...",
            sLoadingRecords: "Cargando...",
            sInfoFiltered: "(filtrando un total de _MAX_ registros)",
            lengthMenu: "Se muestran _MENU_ registros por página",
            sZeroRecords: "No se encontraron resultados",
            sEmptyTable: "Ningún dato disponible en esta tabla",
            info: "Mostrando página _PAGE_ de _PAGES_",
            infoEmpty: "No hay registros disponibles",
            search: "Búsqueda",
            paginate: {
                sFirst: "Primero",
                sLast: "Último",
                previous: "Anterior",
                next: "Siguiente"
            },
            infoFiltered: "(filtered from _MAX_ total records)"
        }
    });

    t.on('order.dt search.dt', function () {
        t.column(0, { search: 'applied', order: 'applied' }).nodes().each(function (cell, i) {
            cell.innerHTML = i + 1;
        });
    }).draw();
}


function CambiarPassword(id) {

    var index = registros.findIndex(a => a.id_usuario == id);
    var dto = registros[index];

    $("#hfId").val(id);
    $("#txtClave").val("");

    $('#spTituloClave').html('Editar clave al usuario: ' + dto.usuario);
    $('#procesoClave').modal('show');
}



async function Password() {

    var id = $("#hfId").val();
    var clave = $("#txtClaveCambio").val().trim();

    if (clave == "") {
        MensajeError("Ingrese Clave");
        return;
    }

    var dto = { clave: clave };

    $("#divLoading").show();
    let result = await putData(api + "/password/" + id, dto);
    $("#divLoading").hide();

    if (result.error != "") {
        MensajeError(result.error);
        return;
    }

    MensajeExitoso("registro actualizado");

    $("#hfId").val("");
    CargarRegistros();

    $('#procesoClave').modal('hide');
}