$(document).ready(function () {

    GetUser();
    CargarTabla([]);
    CargarEstados();
    CargarContrato();

    $("#btnNuevo").click(function (e) {
        Nuevo();
        return true;
    });

    $("#btnAlmacenar").click(function (e) {
        Almacenar();
        return true;
    });

    $("#btnRegresar").click(function (e) {
        Regresar();
        return true;
    });

});

var api = "/local/transacciones";
var registros = [];


function GetUser() {
    let user = sessionStorage.getItem("usuario");
    if (user != null) $("#spUsuario").text("@" + user);
}


function Regresar() {
    window.location.href = "/contract";
}

function getParameterByName(name) {
    name = name.replace(/[\[\]]/g, "\\$&");
    const urlParams = new URLSearchParams(window.location.search);
    return urlParams.get(name);
}


async function CargarEstados() {

    var result = await getData("/local/estatus");

    if (result.error) {
        MensajeError(result.error);
        return;
    }

    var estados = result;
    console.log(estados);
    var items = "<option value='0'>Seleccione Estatus</option>";

    for (var i = 0; i < estados.length; i++) {
        var dto = estados[i];
        items += "<option value='" + dto.id_estatus + "'>" + dto.nombre + "</option>";
    }

    $("#ddlEstatus").html(items);
}


async function CargarContrato() {

    var id = getParameterByName("id");
    $("#hfId").val(id);
    var result = await getData("/local/contratos/" + id);

    if (result.error) {
        MensajeError(result.error);
        return;
    }

    var contratos = result;
    var index = contratos.findIndex(a => a.id_contrato == id);
    var dto = contratos[index];

    if (!dto) {
        MensajeError("No existe proyecto");
        return;
    }

    $("#lblProyecto").text("Proyecto: " + dto.codigo + " - " + dto.referencia);
    CargarRegistros();
}


async function CargarRegistros() {

    try {
        var id = $("#hfId").val();
        $("#divLoading").show();
        var result = await getData("/local/transacciones/contrato/" + id);
        $("#divLoading").hide();

        if (result.error) {
            MensajeError(result.error);
            return;
        }

        registros = result;
        CargarTabla(registros);
    }
    catch (err) {
        MensajeError(err.message);
    }
}



function Nuevo() {

    $("#txtNombre").val("");

    $('#spTitulo').html('Nuevo Estatus');
    $('#procesoModal').modal('show');
}


async function Almacenar() {

    var result;
    var id = $("#hfId").val();
    var idEstatus = $("#ddlEstatus").val();

    if (idEstatus == 0) {
        MensajeError("Seleccion Estatus");
        return;
    }

    var dto = { id_contrato: parseInt(id), id_estatus: parseInt(idEstatus) };

    $("#divLoading").show();
    result = await postData(api, dto);
    $("#divLoading").hide();

    if (result.error) {
        MensajeError(result.error);
        return;
    }

    MensajeExitoso("registro almacenado");
    CargarRegistros();

    $('#procesoModal').modal('hide');
}



function Editar(id) {

    var index = registros.findIndex(a => a.id_estatus == id);
    var dto = registros[index];

    $("#hfId").val(id);
    $("#txtNombre").val(dto.nombre);

    $('#spTitulo').html('Editar Estatus');
    $('#procesoModal').modal('show');
}


function CargarTabla(dataSet) {
    var t = $('#tbRegistros').DataTable({
        data: dataSet,
        pageLength: 5,
        bLengthChange: false,
        ordering: true,
        destroy: true,
        bPaginate: true,
        bFilter: true,
        //bServerSide: false,
        searching: true,
        autoWidth: false,
        info: true,
        aoColumns: [
            { mData: "id_transaccion" },
            { mData: "estatus" },
            { mData: "createdAt" },
        ],
        aoColumnDefs: [
        ],
        order: [[0, 'desc']], // Esto establecerá el orden inicial en la primera columna (cambiar el índice según sea necesario) en orden descendente
        language: {
            sProcessing: "Procesando...",
            sLoadingRecords: "Cargando...",
            sInfoFiltered: "(filtrando un total de _MAX_ registros)",
            lengthMenu: "Se muestran _MENU_ registros por página",
            sZeroRecords: "No se encontraron resultados",
            sEmptyTable: "Ningún dato disponible en esta tabla",
            info: "Mostrando página _PAGE_ de _PAGES_",
            infoEmpty: "No hay registros disponibles",
            search: "Búsqueda",
            paginate: {
                sFirst: "Primero",
                sLast: "Último",
                previous: "Anterior",
                next: "Siguiente"
            },
            infoFiltered: "(filtered from _MAX_ total records)"
        }
    });

    t.on('order.dt search.dt', function () {
        t.column(0, { search: 'applied', order: 'applied' }).nodes().each(function (cell, i) {
            cell.innerHTML = i + 1;
        });
    }).draw();
}



var infoPdf = {
    error: "",
    nombre: "",
    mime: "application/octet-stream",
    base64: ""
};


function Visor(id, eleccion) {

    var url = directorio + "/" + controller + "/Visor";

    $.ajax({
        async: true,
        type: "POST",
        url: url,
        data: {
            id: id,
            eleccion: eleccion
        },
        beforeSend: function () {
            $("#divLoading").show();
        },
        success: function (result) {
            infoPdf.error = result.error;
            infoPdf.base64 = result.base64;
            infoPdf.nombre = result.nombre;

            if (infoPdf.error != "") {
                MensajeError(infoPdf.error);
                return;
            }

            MostrarVisor(infoPdf.base64);

            $("#pdf-viewer").html("");
            $('#pdfModal').show().scrollTop(0);

            $("#spTituloPdf").text("Visor PDF: " + infoPdf.nombre);
            $('#pdfModal').modal('show');
        },
        error: function (errMsg) {
            MensajeError(errMsg.responseText);
        },
        complete: function () {
            $("#divLoading").hide();
        }
    });
}


function DownloadFile(id, eleccion) {

    var url = directorio + "/" + controller + "/Visor";

    $.ajax({
        async: true,
        type: "POST",
        url: url,
        data: {
            id: id,
            eleccion: eleccion
        },
        beforeSend: function () {
            $("#divLoading").show();
        },
        success: function (result) {
            infoPdf.error = result.error;
            infoPdf.base64 = result.base64;
            infoPdf.nombre = result.nombre;

            if (infoPdf.error != "") {
                MensajeError(infoPdf.error);
                return;
            }

            DescargarArchivo(infoPdf.base64, infoPdf.nombre, infoPdf.mime);
        },
        error: function (errMsg) {
            MensajeError(errMsg.responseText);
        },
        complete: function () {
            $("#divLoading").hide();
        }
    });
}


function DescargarPdf() {

    DescargarArchivo(infoPdf.base64, infoPdf.nombre, infoPdf.mime);
}


function Base64ToUint8Array(base64) {
    const binaryString = atob(base64);
    const len = binaryString.length;
    const bytes = new Uint8Array(len);
    for (let i = 0; i < len; i++) {
        bytes[i] = binaryString.charCodeAt(i);
    }
    return bytes;
}


function MostrarVisor(base64String) {

    const pdfData = Base64ToUint8Array(base64String);
    //const pdfData = new Uint8Array([/* Aquí van los bytes del archivo PDF */]);

    const pdfjsLib = window['pdfjs-dist/build/pdf'];
    pdfjsLib.GlobalWorkerOptions.workerSrc = '/./pdf/pdf.worker.min.js';
    //pdfjsLib.GlobalWorkerOptions.workerSrc = 'https://cdnjs.cloudflare.com/ajax/libs/pdf.js/3.0.279/pdf.worker.min.js';

    const pdfViewer = document.getElementById('pdf-viewer');

    function renderPage(page) {
        const viewport = page.getViewport({ scale: 1.5 });
        const canvas = document.createElement('canvas');
        const context = canvas.getContext('2d');
        canvas.height = viewport.height;
        canvas.width = viewport.width;

        pdfViewer.appendChild(canvas);

        const renderContext = {
            canvasContext: context,
            viewport: viewport
        };

        page.render(renderContext);
    }

    const loadingTask = pdfjsLib.getDocument({ data: pdfData });

    loadingTask.promise.then(pdf => {
        for (let pageNum = 1; pageNum <= pdf.numPages; pageNum++) {
            pdf.getPage(pageNum).then(renderPage);
        }
    }).catch(error => {
        console.error('Error al cargar el visor PDF:', error);
    });

}

