﻿$(function () {

    var recordsTable = 3; // isMobile() ? 5 : 10;

    $("#tbRegistros").DataTable({
        pageLength: recordsTable,
        bLengthChange: false,
        ordering: true,
        destroy: true,
        bPaginate: true,
        bFilter: true,
        //bServerSide: false,
        searching: true,
        autoWidth: false,
        info: true,
        language: {
            sProcessing: "Procesando...",
            sLoadingRecords: "Cargando...",
            sInfoFiltered: "(filtrando un total de _MAX_ registros)",
            lengthMenu: "Se muestran _MENU_ registros por página",
            sZeroRecords: "No se encontraron resultados",
            sEmptyTable: "Ningún dato disponible en esta tabla",
            info: "Mostrando página _PAGE_ de _PAGES_",
            infoEmpty: "No hay registros disponibles",
            search: "Búsqueda",
            paginate: {
                sFirst: "Primero",
                sLast: "Último",
                previous: "Anterior",
                next: "Siguiente"
            },
            infoFiltered: "(filtrado de _MAX_ total registros)"
        }
    });


    $("#tbRegistrosDesc").DataTable({
        pageLength: recordsTable,
        bLengthChange: false,
        ordering: true,
        destroy: true,
        bPaginate: true,
        bFilter: true,
        //bServerSide: false,
        searching: true,
        autoWidth: false,
        info: true,
        order: [[0, 'desc']], // Esto establecerá el orden inicial en la primera columna (cambiar el índice según sea necesario) en orden descendente
        language: {
            sProcessing: "Procesando...",
            sLoadingRecords: "Cargando...",
            sInfoFiltered: "(filtrando un total de _MAX_ registros)",
            lengthMenu: "Se muestran _MENU_ registros por página",
            sZeroRecords: "No se encontraron resultados",
            sEmptyTable: "Ningún dato disponible en esta tabla",
            info: "Mostrando página _PAGE_ de _PAGES_",
            infoEmpty: "No hay registros disponibles",
            search: "Búsqueda",
            paginate: {
                sFirst: "Primero",
                sLast: "Último",
                previous: "Anterior",
                next: "Siguiente"
            },
            infoFiltered: "(filtered from _MAX_ total records)"
        }
    });


    var t = $("#tbRegistrosNum").DataTable({
        pageLength: recordsTable,
        bLengthChange: false,
        ordering: true,
        destroy: true,
        bPaginate: true,
        bFilter: true,
        //bServerSide: false,
        searching: true,
        autoWidth: false,
        info: true,
        language: {
            sProcessing: "Procesando...",
            sLoadingRecords: "Cargando...",
            sInfoFiltered: "(filtrando un total de _MAX_ registros)",
            lengthMenu: "Se muestran _MENU_ registros por página",
            sZeroRecords: "No se encontraron resultados",
            sEmptyTable: "Ningún dato disponible en esta tabla",
            info: "Mostrando página _PAGE_ de _PAGES_",
            infoEmpty: "No hay registros disponibles",
            search: "Búsqueda",
            paginate: {
                sFirst: "Primero",
                sLast: "Último",
                previous: "Anterior",
                next: "Siguiente"
            },
            infoFiltered: "(filtered from _MAX_ total records)"
        }
    });

    t.on('order.dt search.dt', function () {
        t.column(0, { search: 'applied', order: 'applied' }).nodes().each(function (cell, i) {
            cell.innerHTML = i + 1;
        });
    }).draw();

    $("#tbRegistrosNum").show();

    function isMobile() {

        if (navigator.userAgent.match(/Android/i) || navigator.userAgent.match(/webOS/i) || navigator.userAgent.match(/iPhone/i) || navigator.userAgent.match(/iPad/i) || navigator.userAgent.match(/iPod/i) || navigator.userAgent.match(/BlackBerry/i) || navigator.userAgent.match(/Windows Phone/i)) {
            return true;
        }

        return false;
    }

});
