﻿var urlToast = directorio + '/Content/toast/mensajesToast.js';
$.getScript(urlToast);

var urlCSS = directorio + '/Content/toast/toastr.css';
getCss(urlCSS);

function getCss(url) {

    var linkElement = document.createElement('link');
    linkElement.rel = 'stylesheet';
    linkElement.type = 'text/css';
    linkElement.href = url;

    //incluir el css 
    document.getElementsByTagName('head')[0].appendChild(linkElement);
}


var infoPdf = {
    error: "",
    nombre: "",
    mime: "application/octet-stream",
    base64: ""
};


function Visor(id, eleccion) {

    var url = directorio + "/" + controller + "/Visor";

    $.ajax({
        async: true,
        type: "POST",
        url: url,
        data: {
            id: id,
            eleccion: eleccion
        },
        beforeSend: function () {
            $("#divLoading").show();
        },
        success: function (result) {
            infoPdf.error = result.error;
            infoPdf.base64 = result.base64;
            infoPdf.nombre = result.nombre;

            if (infoPdf.error != "") {
                MensajeError(infoPdf.error);
                return;
            }

            MostrarVisor(infoPdf.base64);

            $("#pdf-viewer").html("");
            $('#pdfModal').show().scrollTop(0);

            $("#spTituloPdf").text("Visor PDF: " + infoPdf.nombre);
            $('#pdfModal').modal('show');
        },
        error: function (errMsg) {
            MensajeError(errMsg.responseText);
        },
        complete: function () {
            $("#divLoading").hide();
        }
    });
}


function DownloadFile(id, eleccion) {

    var url = directorio + "/" + controller + "/Visor";

    $.ajax({
        async: true,
        type: "POST",
        url: url,
        data: {
            id: id,
            eleccion: eleccion
        },
        beforeSend: function () {
            $("#divLoading").show();
        },
        success: function (result) {
            infoPdf.error = result.error;
            infoPdf.base64 = result.base64;
            infoPdf.nombre = result.nombre;

            if (infoPdf.error != "") {
                MensajeError(infoPdf.error);
                return;
            }

            DescargarArchivo(infoPdf.base64, infoPdf.nombre, infoPdf.mime);
        },
        error: function (errMsg) {
            MensajeError(errMsg.responseText);
        },
        complete: function () {
            $("#divLoading").hide();
        }
    });
}


function DescargarPdf() {

    DescargarArchivo(infoPdf.base64, infoPdf.nombre, infoPdf.mime);
}


function Base64ToUint8Array(base64) {
    const binaryString = atob(base64);
    const len = binaryString.length;
    const bytes = new Uint8Array(len);
    for (let i = 0; i < len; i++) {
        bytes[i] = binaryString.charCodeAt(i);
    }
    return bytes;
}


function MostrarVisor(base64String) {

    const pdfData = Base64ToUint8Array(base64String);
    //const pdfData = new Uint8Array([/* Aquí van los bytes del archivo PDF */]);

    const pdfjsLib = window['pdfjs-dist/build/pdf'];
    pdfjsLib.GlobalWorkerOptions.workerSrc = directorio + '/Scripts/pdf.worker.min.js';
    //pdfjsLib.GlobalWorkerOptions.workerSrc = 'https://cdnjs.cloudflare.com/ajax/libs/pdf.js/3.0.279/pdf.worker.min.js';

    const pdfViewer = document.getElementById('pdf-viewer');

    function renderPage(page) {
        const viewport = page.getViewport({ scale: 1.5 });
        const canvas = document.createElement('canvas');
        const context = canvas.getContext('2d');
        canvas.height = viewport.height;
        canvas.width = viewport.width;

        pdfViewer.appendChild(canvas);

        const renderContext = {
            canvasContext: context,
            viewport: viewport
        };

        page.render(renderContext);
    }

    const loadingTask = pdfjsLib.getDocument({ data: pdfData });

    loadingTask.promise.then(pdf => {
        for (let pageNum = 1; pageNum <= pdf.numPages; pageNum++) {
            pdf.getPage(pageNum).then(renderPage);
        }
    }).catch(error => {
        console.error('Error al cargar el visor PDF:', error);
    });

}

