$(function () {
    Current();
});


async function Current() {
    
    var data = await getData("http://ip-api.com/json");
    await Load(data.lat, data.lon, 1);
}


var map;  

async function Load(lat, lon, type) {
    if (map) {
        
        map.setView([lat, lon], 15);
    } else {

        map = L.map('contenido').setView([lat, lon], 15);

        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
            attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors'
        }).addTo(map);
    }

    map.eachLayer(function (layer) {
        if (layer instanceof L.Marker) {
            map.removeLayer(layer);
        }
    });

    L.marker([lat, lon]).addTo(map);
}
