const dayjs = require('dayjs');

module.exports = (sequelize, Sequelize) => {

    const modelo = sequelize.define("usuario", {
        id_usuario: { type: Sequelize.INTEGER, primaryKey: true, autoIncrement: true },
        nombre: { type: Sequelize.STRING, max: 100, allowNull: false },
        usuario: { type: Sequelize.STRING, max: 100, allowNull: false },
        clave: { type: Sequelize.STRING, max: 100, allowNull: false },
        createdAt: {
            type: Sequelize.DATE, allowNull: false, default: new Date(),
            get() {
                const fecha = this.getDataValue('createdAt');
                return dayjs(fecha).format('YYYY-MM-DD HH:mm');
            }
        },
        updatedAt: { type: Sequelize.DATE, allowNull: false, default: new Date() },
        tipo: {
            type: Sequelize.STRING, max: 100, allowNull: false, field: "TIPO",
            validate: {
                isIn: {
                    args: [['ADMIN', 'USER']],
                    msg: "El tipo debe ser 'ADMIN' o 'USER'"
                }
            }
        },
    }, {
        timestamps: true,
        paranoid: false,
        freezeTableName: false,
        tableName: 'usuario'
    });


    //  // Asociaciones
    //  modelo.associate = (db) => {
    //     modelo.hasMany(db.bucket, { foreignKey: 'id_usuario' }); // Relación con Repositorio
    // };


    return modelo;
};