const dayjs = require('dayjs');

module.exports = (sequelize, Sequelize) => {

    const modelo = sequelize.define("transaccion", {
        id_transaccion: { type: Sequelize.INTEGER, primaryKey: true, autoIncrement: true },
        id_contrato: { type: Sequelize.INTEGER, allowNull: false },
        id_estatus: { type: Sequelize.INTEGER, allowNull: false },
        createdAt: { type: Sequelize.DATE, allowNull: false, default: new Date(),
            get() {
                const fecha = this.getDataValue('createdAt');
                return dayjs(fecha).format('YYYY-MM-DD HH:mm'); 
            }
         },
        updatedAt: { type: Sequelize.DATE, allowNull: false, default: new Date() }
    }, {
        timestamps: true,
        paranoid: false,
        freezeTableName: false,
        tableName: 'transaccion'
    });


     // Asociaciones
    modelo.associate = (models) => {
        modelo.belongsTo(models.contrato, { foreignKey: 'id_contrato' }); // Relación con Conrtato
        modelo.belongsTo(models.estatus, { foreignKey: 'id_estatus' }); // Relación con Estatus
    };

    return modelo;
};