const dayjs = require('dayjs');

module.exports = (sequelize, Sequelize) => {

    const modelo = sequelize.define("documento", {
        id_documento: { type: Sequelize.INTEGER, primaryKey: true, autoIncrement: true },
        nombre: { type: Sequelize.STRING, max: 100, allowNull: false },
        ruta: { type: Sequelize.STRING, max: 100, allowNull: false },
        id_contrato: { type: Sequelize.INTEGER, allowNull: false },
        createdAt: { type: Sequelize.DATE, allowNull: false, default: new Date(),
            get() {
                const fecha = this.getDataValue('createdAt');
                return dayjs(fecha).format('YYYY-MM-DD HH:mm'); 
            }
         },
        updatedAt: { type: Sequelize.DATE, allowNull: false, default: new Date() }
    }, {
        timestamps: true,
        paranoid: false,
        freezeTableName: false,
        tableName: 'documento'
    });

    return modelo;
};