const express = require('express');
const path = require('path');
const session = require('express-session');
const cookieParser = require('cookie-parser');
//const jwt = require('jsonwebtoken');
const fileUpload = require('express-fileupload');

const app = express();
const PORT = process.env.PORT || 4000;

app.use(express.json());
app.use(express.urlencoded({ extended: true }));
app.use(cookieParser());
app.use(fileUpload());
app.use(express.static(path.join(__dirname, 'public')));

app.use(session({
    secret: '34SDgsJvRcFwXqRpttCs',
    resave: false,
    saveUninitialized: true,
}));

const db = require('./models/index.js');
db.sequelize.sync({ force: false });

var usuarioRouter = require('./routes/usuario.js')
var estatusRourter = require('./routes/estatus.js')
var contratoRourter = require('./routes/contrato.js')
var transaccionRourter = require('./routes/transaccion.js')
var documentoRourter = require('./routes/documento.js')
var publicRouter = require('./routes/public.js')

//rutas protegidas
app.use('/local/usuarios', requireLogin, usuarioRouter);
app.use('/local/estatus', requireLogin, estatusRourter);
app.use('/local/contratos',  requireLogin, contratoRourter);
app.use('/local/transacciones', requireLogin, transaccionRourter);
app.use('/local/documentos', requireLogin, documentoRourter);

//rutas libres
app.use('/metal', usuarioRouter);
app.use('/public', publicRouter);


//interfaces
app.get('/', function (req, res) {
    return res.sendFile(path.join(__dirname, 'public', 'login.html'));
});

app.get('/home', (req, res) => {
    return res.sendFile(path.join(__dirname, 'public', 'home.html'));
});

app.get('/user', requireLogin, (req, res) => {
    return res.sendFile(path.join(__dirname, 'public', 'user.html'));
});

app.get('/status', requireLogin, (req, res) => {
    return res.sendFile(path.join(__dirname, 'public', 'stat.html'));
});

app.get('/contract', requireLogin, (req, res) => {
    return res.sendFile(path.join(__dirname, 'public', 'contract.html'));
});

app.get('/transaction', requireLogin, (req, res) => {
    return res.sendFile(path.join(__dirname, 'public', 'transaccion.html'));
});

app.get('/upload', requireLogin, (req, res) => {
    return res.sendFile(path.join(__dirname, 'public', 'upload.html'));
});

app.get('/indicador', requireLogin, (req, res) => {
    return res.sendFile(path.join(__dirname, 'public', 'indicadores.html'));
});


app.get('/smart', (req, res) => {
    return res.sendFile(path.join(__dirname, 'public', 'smart.html'));
});


app.get('/logout', function (req, res) {
    req.session.destroy();
    res.redirect('/');
});


app.post('/login', async (req, res) => {
    const usuario = require('./controllers/usuario.js');
    return usuario.login(req, res);
});


function requireLogin(req, res, next) {
    if (req.session.loggedIn) {
        next(); // allow the next route to run
    } else {
        // require the user to log in
        return res.redirect("/"); // or render a form, etc.
    }
}


/*
app.post('/upload2', (req, res) => {
    try {

        if (!req.files || !req.files.documento) {
            return res.status(400).json({ error: 'No se proporcionó ningún archivo' });
        }

        const archivo = req.files.documento;
        console.log(archivo);
        console.log('Archivo recibido:', archivo.name); // Mostrar el nombre del archivo recibido
        return res.send({ mensaje: 'Archivo subido con éxito' });
    }
    catch (err) {
        return res.send(500).send({ error: "error: " + err.message })
    }
});


function autenticarToken(req, res, next) {
    const token = req.headers['authorization'];

    if (!token) {
        return res.status(401).json({ mensaje: 'Acceso denegado: No se proporcionó un token' });
    }

    // Remover "Bearer " del token
    const tokenSinBearer = token.split(' ')[1];

    jwt.verify(tokenSinBearer, 'miSecretaClave', (err, user) => {
        if (err) {
            return res.status(403).json({ mensaje: 'Token inválido' });
        }

        req.user = user; // Agrega el usuario decodificado al objeto `req` para su uso posterior
        next(); // Continua a la siguiente función de middleware o la ruta
    });
}
*/

// app.post('/upload', async (req, res) => {

//     try {

//         const postUrl = 'http://localhost:3000/upload2';
//         const parametros = { ambiente: "desa", subfolder: "pdf" };
//         const data = await postData(postUrl, parametros);
//         console.log(data);

//         return res.status(200).send(data);

//     }
//     catch (err) {
//         return res.status(500).send({ error: "error: " + err.message })
//     }
// });


// app.post('/', async (req, res) => {

//     try {

//         let sql = req.body.sql || "";
//         console.log(req.body);

//         if (sql == "") return res.status(400).send({ error: "ingrese sql" });

//         // Uso de la función para hacer una solicitud POST
//         const postUrl = 'http://localhost:3000/api/db/select';
//         //const parametros = { sql: "select * from empleado where id_empleado = 1" };
//         const data = await postData(postUrl, sql);
//         console.log(data);

//         return res.status(200).send(data);

//     }
//     catch (err) {
//         return res.status(500).send({ error: "error: " + err.message })
//     }

// });


app.listen(PORT, async () => {

    console.log(`Servidor ejecutándose en http://localhost: ${PORT}`);
});