exports.isDecimal = (text) => {
    return !isNaN(text);
}

exports.isInteger = (text) => {
    return Number.isInteger(Number(text));
}

exports.isValidEmail = (email) => {
    const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
    return emailRegex.test(email);
}


exports.randomText = (x) => {
    const caracteres = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    let codigo = '';

    for (let i = 0; i < x; i++) {
        const indice = Math.floor(Math.random() * caracteres.length);
        codigo += caracteres.charAt(indice);
    }

    return codigo;
}


exports.randomNumbers = (x) => {
    const caracteres = '123456789';
    let codigo = '';

    for (let i = 0; i < x; i++) {
        const indice = Math.floor(Math.random() * caracteres.length);
        codigo += caracteres.charAt(indice);
    }

    return codigo;
}



exports.generatePDF = async function (html) {

    let pdf = require("html-pdf");
    let error = "";
    let base64 = "";
    let bytes;

    if (html === "") return { error: "ingrese html" };

    try {

        // var options = {
        //     format: 'Letter',
        //     orientation: 'portrait', // Asegura que el PDF esté en orientación vertical
        //     margin: { top: '1in', left: '0.5in', right: '0.5in', bottom: '0.5in' }, // Establece los márgenes
        //     timeout: 30000
        // };

        var options = {
            format: 'Letter',
            timeout: 30000
        };

        base64 = await new Promise((resolve, reject) => {
            pdf.create(html, options).toBuffer((err, buffer) => {
                if (err) return reject(err.message);
                bytes = buffer;
                resolve(buffer.toString('base64'));
            });
        });

    } catch (err) {
        error = err.message;
    }

    return { error: error, base64: base64, bytes }
}



exports.createPDF = async (text) => {
    const { jsPDF } = require('jspdf');
    let error = "";
    let base64 = "";
    let bytes = "";

    try {
        // Crear un nuevo documento PDF
        const doc = new jsPDF({
            unit: 'in',      // Definir la unidad de medida en pulgadas
            format: 'letter' // Tamaño carta (8.5x11 pulgadas)
        });

        // Definir los márgenes y configuraciones del texto
        const marginLeft = 1; // 1 pulgada de margen a la izquierda
        const marginRight = 1; // 1 pulgada de margen a la derecha
        const pageWidth = 8.5; // Ancho de la página en pulgadas
        const textWidth = pageWidth - marginLeft - marginRight; // Ancho del texto

        // Agregar el texto justificado
        const lines = doc.splitTextToSize(text, textWidth); // Ajustar el texto a los márgenes
        doc.text(lines, marginLeft, 1, { align: 'justify' }); // Posicionar el texto en la página

        // Generar el PDF como ArrayBuffer
        const pdfBytes = await doc.output('arraybuffer');

        // Convertir a Base64
        base64 = Buffer.from(pdfBytes).toString('base64');
        bytes = pdfBytes;
    } catch (err) {
        error = err.message;
    }

    return { error, base64, bytes };
}







exports.postData = async (apiUrl, dataToSend) => {
    return await callApi(apiUrl, dataToSend, 'POST');
}

exports.putData = async (apiUrl, dataToSend) => {
    return await callApi(apiUrl, dataToSend, 'PUT');
}

exports.getData = async (apiUrl) => {

    var data;

    try {

        // Realizamos la solicitud fetch y esperamos la respuesta
        const response = await fetch(apiUrl);
        const status = response.status;
        data = await response.json();

        if (status != 200) {
            data.error = "Error:  " + data.error;
        }

    } catch (err) {
        data.error = err.message;
    }

    return data;
}


async function callApi(apiUrl, dataToSend, method) {
    var data;

    // Configuración de la solicitud
    const requestOptions = {
        method: method,
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify(dataToSend)
    };

    try {
        // Realizamos la solicitud fetch y esperamos la respuesta
        const response = await fetch(apiUrl, requestOptions);
        const status = response.status;
        data = await response.json();

        if (status != 200) {
            data.error = "Error:  " + data.error;
        }

    } catch (err) {
        data = err.message;
    }

    return data;
}


exports.deleteData = async (apiUrl) => {
    var error = "";

    // Configuración de la solicitud DELETE
    const requestOptions = {
        method: 'DELETE'
    };

    try {
        // Realizamos la solicitud fetch y esperamos la respuesta
        const response = await fetch(apiUrl, requestOptions);
        const status = response.status;
        const data = await response.json();

        //console.log('Respuesta del servidor:', data);

        if (status != 200) {
            error = "Error:  " + data.mensaje;
        }

    } catch (error) {
        error = error.message;
    }

    return error;
}


exports.formatNumber = (number) => {
    const formattedNumber = new Intl.NumberFormat('en-US', {
        style: 'decimal',
        minimumFractionDigits: 2,
        maximumFractionDigits: 2
    }).format(number);

    return formattedNumber;
}



/*
exports.uploadFile = async (ambiente, subfolder, documento) => {

    const FormData = require('form-data');
    let result;

    try {

        if (ambiente == "") return result.error = 'ingrese ambiente';
        if (subfolder == "") return result.error = 'ingrese subfolder';
        if (!documento instanceof ArrayBuffer) return result.error = 'El archivo proporcionado no es un ArrayBuffer';

        // Crea un objeto FormData
        const form = new FormData();
        form.append('ambiente', ambiente);
        form.append('subfolder', subfolder);
        form.append('documento', documento);

        const response = await fetch('http://localhost:5000/upload-base64', {
        //const response = await fetch('https://bucket.code-makers.com/upload', {
            method: 'POST',
            body: form,
            headers: {
                ...form.getHeaders(), // Incluye los headers necesarios para multipart/form-data
            }
        });

        // if (!response.ok) {
        //     throw new Error(`Error al subir archivo: ${response.statusText}`);
        // }

        result = await response.json();
        console.log('Respuesta de la API:', result);
    } catch (err) {
        console.log('fallo de la API: ', err.message);
        result.error = "Error: " + err.message;
    }

    return result;
}
*/