const { where } = require("sequelize");
const db = require("../models");
const model = db.estatus;
const Op = db.Sequelize.Op;


exports.get = async (req, res) => {
    try {
        const id = req.params.id;
        var condition = id ? { id_usuario: id } : null;

        const data = await model.findAll({ where: condition, order: [['nombre', 'ASC']], });
        return res.status(200).send(data);
    }
    catch (err) {
        return res.status(500).send({ error: "error: " + err.message })
    }
}


exports.post = async (req, res) => {
    try {

        if (!req.body.nombre) return res.status(400).send({ error: "ingrese nombre" });

        var nombre = req.body.nombre;
        var condition = nombre ? { nombre: { [Op.like]: `%${nombre}%` } } : null;

        var registros = await model.findAll({ where: condition })

        if (registros.length > 0) return res.status(400).send({ error: "ya existe registro con ese nombre" });

        await model.create({
            nombre: req.body.nombre.toUpperCase(),
        });

        return res.status(200).send({ mensaje: "Registro almacenado exitosamente", error: "" });
    }
    catch (err) {
        return res.status(500).send({ error: "error: " + err.message })
    }
};


exports.put = async (req, res) => {
    try {
        if (!req.params.id) return res.status(400).send({ error: "ingrese id" });
        if (!req.body.nombre) return res.status(400).send({ error: "ingrese nombre" });

        var id = req.params.id;
        var nombre = req.body.nombre.toUpperCase();
        var condition = { nombre: nombre, id_estatus: { [Op.not]: id } };
        
        var registros = await model.count({ where: { id_estatus: id } });
        if (registros == 0) return res.status(404).send({ error: "No existe registro con el id: " + id });

        registros = await model.count({ where: condition });
        if (registros > 0) return res.status(400).send({ error: "ya existe registro con ese nombre" });

        await model.update(
            {
                nombre: nombre,
            },
            {
                where: { id_estatus: id }
            }
        );

        return res.status(200).send({ mensaje: "Registro actualizado exitosamente" });
    }
    catch (err) {
        return res.status(500).send({ error: "error: " + err.message })
    }
};


exports.delete = async (req, res) => {
    try {
        if (!req.params.id) return res.status(400).send({ error: "ingrese id" });

        let id = req.params.id;

        var registros = await model.count({ where: { id_estatus: id } });

        if (registros == 0) return res.status(404).send({ error: "No existe registro con el id: " + id });

        let llaves = await model.contratos.count({ where: { id_estatus: id } });

        if (llaves > 0) return res.status(404).send({ error: "no es posible borrar el registro, porque posee otros registros asociados" });

        await model.destroy({
            where: { id_estatus: id }
        });

        return res.status(200).send({ mensaje: "Registro elimiando exitosamente" });
    }
    catch (err) {
        return res.status(500).send({ error: "error: " + err.message })
    }
};
