const db = require("../models");
const model = db.documento;
const Op = db.Sequelize.Op;
const { isInteger } = require('../helpers/util');


exports.get = async (req, res) => {
    try {
        const id = req.params.id;
        var condition = id ? { id_documento: id } : null;

        const data = await model.findAll({ where: condition, order: [['id_documento', 'ASC']], });
        return res.status(200).send(data);
    }
    catch (err) {
        return res.status(500).send({ error: "error: " + err.message })
    }
}


exports.post = async (req, res) => {
    try {

        let nombre = req.body.nombre?.trim() ?? "";
        let id_contrato = req.body.id_contrato?.trim() ?? "";

        if (nombre) return res.status(400).send({ error: "ingrese nombre" });
        if (id_contrato) return res.status(400).send({ error: "ingrese id_contrato" });
        if (!isInteger(id_contrato)) return res.status(400).send({ error: "ingrese valor entero en id_contrato" });

        var condition = { id_contrato: id_contrato, nombre: nombre.toUpperCase() };
        var registros = await model.count({ where: condition })

        if (registros > 0) return res.status(400).send({ error: "ya existe registro con esos datos" });

        await model.create({
            id_contrato: id_contrato,
            nombre: nombre.toUpperCase()
        });

        return res.status(200).send({ mensaje: "Registro almacenado exitosamente", error: "" });
    }
    catch (err) {
        return res.status(500).send({ error: "error: " + err.message })
    }
};


exports.put = async (req, res) => {
    try {

        let nombre = req.body.nombre?.trim() ?? "";
        let id_contrato = req.body.id_contrato?.trim() ?? "";

        if (!req.params.id) return res.status(400).send({ error: "ingrese id" });
        if (nombre) return res.status(400).send({ error: "ingrese nombre" });
        if (id_contrato) return res.status(400).send({ error: "ingrese id_contrato" });
        if (!isInteger(id_contrato)) return res.status(400).send({ error: "ingrese valor entero en id_contrato" });

        var id = req.params.id;
        var condition = { id_contrato: id_contrato, nombre: nombre.toUpperCase(), id_documento: { [Op.not]: id } };

        var registros = await model.count({ where: { id_documento: id } });
        if (registros == 0) return res.status(404).send({ error: "No existe registro con el id: " + id });

        registros = await model.count({ where: condition });
        if (registros > 0) return res.status(400).send({ error: "ya existe registro con esos datos" });

        await model.update(
            {
                id_contrato: id_contrato,
                nombre: nombre.toUpperCase()
            },
            {
                where: { id_documento: id }
            }
        );

        return res.status(200).send({ mensaje: "Registro actualizado exitosamente" });
    }
    catch (err) {
        return res.status(500).send({ error: "error: " + err.message })
    }
};


exports.delete = async (req, res) => {
    try {
        if (!req.params.id) return res.status(400).send({ error: "ingrese id" });

        let id = req.params.id;

        var registros = await model.count({ where: { id_documento: id } });

        if (registros == 0) return res.status(404).send({ error: "No existe registro con el id: " + id });

        await model.destroy({
            where: { id_documento: id }
        });

        return res.status(200).send({ mensaje: "Registro elimiando exitosamente" });
    }
    catch (err) {
        return res.status(500).send({ error: "error: " + err.message })
    }
};
