const db = require("../models");
const model = db.contrato;
const Op = db.Sequelize.Op;
const { isDecimal, isInteger, isValidEmail, randomNumbers, randomText } = require('../helpers/util');


exports.get = async (req, res) => {
    try {
        const id = req.params.id;
        var condition = id ? { id_contrato: id } : null;

        const data = await model.findAll({ where: condition, order: [['id_contrato', 'ASC']], });
        return res.status(200).send(data);
    }
    catch (err) {
        return res.status(500).send({ error: "error: " + err.message })
    }
}


exports.getCode = async (req, res) => {
    try {

        let code = req.params.code?.trim() ?? "";
        if (code == "") return res.status(400).send({ error: "input code" });

        const data = await model.findOne({ where: { codigo: code } });
        if (!data) return res.status(404).send({ error: "It doesn't exist record with code: " + code });

        return res.status(200).send(data);
    }
    catch (err) {
        return res.status(500).send({ error: "error: " + err.message })
    }
}


exports.post = async (req, res) => {
    try {

        let referencia = req.body.referencia?.trim() ?? "";
        let empresa = req.body.empresa?.trim() ?? "";
        let responsable = req.body.responsable?.trim() ?? "";
        let email = req.body.email?.trim() ?? "";
        let meses = req.body.meses?.trim() ?? "";
        let costo = req.body.costo?.trim() ?? "";

        if (referencia == "") return res.status(400).send({ error: "ingrese referencia" });
        if (empresa == "") return res.status(400).send({ error: "ingrese empresa" });
        if (responsable == "") return res.status(400).send({ error: "ingrese responsable" });
        if (email == "") return res.status(400).send({ error: "ingrese email" });
        if (!isValidEmail(email)) return res.status(400).send({ error: "ingrese correo válido" });
        if (meses == "") return res.status(400).send({ error: "ingrese meses" });
        if (costo == "") return res.status(400).send({ error: "ingrese costo" });
        if (!isInteger(meses)) return res.status(400).send({ error: "ingrese valor entero en meses" });
        if (!isDecimal(costo)) return res.status(400).send({ error: "ingrese valor decimal en costo" });


        var condition = { referencia: referencia.toUpperCase() };
        var registros = await model.count({ where: condition });
        if (registros > 0) return res.status(404).send({ error: "ya existe un registro con esa referencia" });


        let puesto = req.body.puesto || null;
        let direccion = req.body.direccion || null;
        let telefono = req.body.telefono || null;
        let codigo = randomNumbers(3) + randomText(3);

        await model.create({
            codigo: codigo,
            referencia: referencia.toUpperCase(),
            meses: meses,
            costo: costo,
            referencia: referencia,
            empresa: empresa.toUpperCase(),
            responsable: responsable.toUpperCase(),
            puesto: puesto?.toUpperCase() ?? null,
            email: email.toLowerCase(),
            direccion: direccion?.toUpperCase() ?? null,
            telefono: telefono?.toUpperCase() ?? null,
        });

        console.log("almacenado correctamente");

        return res.status(200).send({ mensaje: "Registro almacenado exitosamente" });
    }
    catch (err) {
        console.log(err.message);
        return res.status(500).send({ error: "error: " + err.message })
    }
};


exports.put = async (req, res) => {
    try {

        if (!req.params.id) return res.status(400).send({ error: "ingrese id" });
        let referencia = req.body.referencia?.trim() ?? "";
        let empresa = req.body.empresa?.trim() ?? "";
        let responsable = req.body.responsable?.trim() ?? "";
        let email = req.body.email?.trim() ?? "";
        let meses = req.body.meses?.trim() ?? "";
        let costo = req.body.costo?.trim() ?? "";

        if (referencia == "") return res.status(400).send({ error: "ingrese referencia" });
        if (empresa == "") return res.status(400).send({ error: "ingrese empresa" });
        if (responsable == "") return res.status(400).send({ error: "ingrese responsable" });
        if (email == "") return res.status(400).send({ error: "ingrese email" });
        if (!isValidEmail(email)) return res.status(400).send({ error: "ingrese correo válido" });
        if (meses == "") return res.status(400).send({ error: "ingrese meses" });
        if (costo == "") return res.status(400).send({ error: "ingrese costo" });
        if (!isInteger(meses)) return res.status(400).send({ error: "ingrese valor entero en meses" });
        if (!isDecimal(costo)) return res.status(400).send({ error: "ingrese valor decimnal en costo" });


        let puesto = req.body.puesto || null;
        let direccion = req.body.direccion || null;
        let telefono = req.body.telefono || null;

        var id = req.params.id;
        var condition = { referencia: referencia.toUpperCase(), id_contrato: { [Op.not]: id } };

        var registros = await model.count({ where: { id_contrato: id } });
        if (registros == 0) return res.status(404).send({ error: "No existe registro con el id: " + id });

        registros = await model.count({ where: condition });
        if (registros > 0) return res.status(400).send({ error: "ya existe registro con esa referencia" });


        await model.update(
            {
                meses: meses,
                referencia: referencia.toUpperCase(),
                empresa: empresa.toUpperCase(),
                responsable: responsable.toUpperCase(),
                puesto: puesto?.toUpperCase() ?? null,
                email: email.toLowerCase(),
                direccion: direccion?.toUpperCase() ?? null,
                telefono: telefono?.toUpperCase() ?? null,
            },
            {
                where: { id_contrato: id }
            }
        );

        return res.status(200).send({ mensaje: "Registro almacenado exitosamente" });
    }
    catch (err) {
        return res.status(500).send({ error: "error: " + err.message })
    }
};


exports.delete = async (req, res) => {
    try {
        if (!req.params.id) return res.status(400).send({ error: "ingrese id" });

        let id = req.params.id;

        var registros = await model.count({ where: { id_contrato: id } });
        if (registros == 0) return res.status(404).send({ error: "No existe registro con el id: " + id });

        await model.destroy({
            where: { id_contrato: id }
        });

        return res.status(200).send({ mensaje: "Registro elimiando exitosamente" });
    }
    catch (err) {
        return res.status(500).send({ error: "error: " + err.message })
    }
};

